"""Czysty kod w Pythonie - Rozdział 7: Generatory, iteratory i programowanie asynchroniczne

> Generatory łańcuchowe o składni ``yield from``.

"""


def chain(*iterables):
    """
    >>> list(chain("witaj", ["świecie"], ("krotka", " kilku ", "wartości."))) 
    ['w', 'i', 't', 'a', 'j', 'świecie', 'krotka', ' kilku ', 'wartości.']
    """
    for it in iterables:
        yield from it


def _chain(*iterables):
    for it in iterables:
        for value in it:
            yield value


def all_powers(n, power):
    yield from (n ** i for i in range(power + 1))
