"""Czysty kod w Pythonie - Rozdział 4: Zasady SOLID

> Zasada podstawiania Liskov (LSP)

Wykrywanie naruszeń LSP z użyciem narzędzi (mypy, pylint, etc.)
"""


class Event:
    ...

    def meets_condition(self, event_data: dict) -> bool:
        return False


class LoginEvent(Event):
    def meets_condition(self, event_data: list) -> bool:
        return bool(event_data)


class LogoutEvent(Event):
    def meets_condition(self, event_data: dict, override: bool) -> bool:
        if override:
            return True
        ...
