"""Czysty kod w Pythonie - Rozdział 2: Kod pythoniczny

> Dynamic Attributes

"""


class DynamicAttributes:
    """
    >>> dyn = DynamicAttributes("wartość")
    >>> dyn.attribute
    'value'

    >>> dyn.fallback_test
    '[fallback resolved] test'

    >>> dyn.__dict__["fallback_new"] = "nowa wartość"
    >>> dyn.fallback_new
    'nowa wartość'

    >>> getattr(dyn, "coś", "domyślnie")
    'default'
    """

    def __init__(self, attribute):
        self.attribute = attribute

    def __getattr__(self, attr):
        if attr.startswith("fallback_"):
            name = attr.replace("fallback_", "")
            return f"[fallback resolved] {name}"
        raise AttributeError(
            f"{self.__class__.__name__} nie ma atrybutu {attr}"
        )
