"""Czysty kod w Pythonie - Rozdział 7: Generatory, iteratory i programowanie asynchroniczne

> yield from: przechwytywanie zwracanej wartości.
"""

from log import logger


def sequence(name, start, end):
    logger.info("%s rozpoczęto od %i", name, start)
    yield from range(start, end)
    logger.info("%s zakończono na %i", name, end)
    return end


def main():
    step1 = yield from sequence("pierwszy", 0, 5)
    step2 = yield from sequence("drugi", step1, 10)
    return step1 + step2
