"""Czysty kod w Pythonie - Rozdział 6: Deskryptory

> Typy deskryptorów:

    1. Deskryptory Non-Data (nieprzesłaniane)
    2. Deskryptory danych (przesłaniane)

Przykłady kodu ilustrujące typ [1].
"""


class NonDataDescriptor:
    """Deskryptor, który nie implementuje metody __set__."""

    def __get__(self, instance, owner):
        if instance is None:
            return self
        return 42


class ClientClass:
    """Test NonDataDescriptor.

    >>> client = ClientClass()
    >>> client.descriptor
    42

    >>> client.descriptor = 43
    >>> client.descriptor
    43

    >>> del client.descriptor
    >>> client.descriptor
    42

    >>> vars(client)
    {}

    >>> client.descriptor
    42

    >>> client.descriptor = 99
    >>> vars(client)
    {'descriptor': 99}

    >>> del client.descriptor
    >>> vars(client)
    {}
    >>> client.descriptor
    42

    """

    descriptor = NonDataDescriptor()
