"""Czysty kod w Pythonie - Rozdział 6: Deskryptory

> Metody interfejsu deskryptora: __get__
"""


class DescriptorClass:
    def __get__(self, instance, owner):
        if instance is None:
            return f"{self.__class__.__name__}.{owner.__name__}"
        return f"wartość dla obiektu {instance}"


class ClientClass:
    """
    >>> ClientClass.descriptor
    'DescriptorClass.ClientClass'

    >>> ClientClass().descriptor  # doctest: +ELLIPSIS
    'wartość dla <descriptors_methods_1.ClientClass object at 0x...>'
    """

    descriptor = DescriptorClass()
