"""Czysty kod w Pythonie - Rozdział 6: Deskryptory

> Jak Python używa wewnętrznie deskryptorów.

"""
from types import MethodType


class Method:
    def __init__(self, name):
        self.name = name

    def __call__(self, instance, arg1, arg2):
        print(f"{self.name}: {instance} wywołana z argumentami {arg1} i {arg2}")


class MyClass1:
    method = Method("Wywołanie wewnętrzne")


class NewMethod:
    def __init__(self, name):
        self.name = name

    def __call__(self, instance, arg1, arg2):
        print(f"{self.name}: {instance} wywołana z argumentami {arg1} i {arg2}")

    def __get__(self, instance, owner):
        if instance is None:
            return self
        return MethodType(self, instance)


class MyClass2:
    method = NewMethod("Wywołanie wewnętrzne")
