"""Czysty kod w Pythonie – Rozdział 6: Pełniejsze wykorzystywanie obiektów dzięki 
deskryptorom


> Ilustracja podstawowego działania protokołu deskryptora

"""
import logging

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)


class DescriptorClass:
    def __get__(self, instance, owner):
        if instance is None:
            return self
        logger.info(
            "Wywołanie: %s.__get__(%r, %r)",
            self.__class__.__name__,
            instance,
            owner,
        )
        return instance


class ClientClass:
    descriptor = DescriptorClass()
