"""Czysty kod w Pythonie - Rozdział 5: Dekoratory

> Podział odpowiedzialności (SoC).
    Rozdzielenie sprzężonego dekoratora na mniejsze.
"""
import functools
import time

from log import logger


def traced_function(function):
    @functools.wraps(function)
    def wrapped(*args, **kwargs):
        logger.info("początek działania funkcji %s", function.__qualname__)
        start_time = time.time()
        result = function(*args, **kwargs)
        logger.info(
            "działanie funkcji %s zajęło %.2fs",
            function.__qualname__,
            time.time() - start_time,
        )
        return result

    return wrapped


@traced_function
def operation1():
    time.sleep(2)
    logger.info("uruchomiona funkcja operation1")
    return 2
