"""Czysty kod w Pythonie - Rozdział 7: Generatory, iteratory i programowanie asynchroniczne

> yield from: wysyłanie wartości i zgłaszanie wyjątków

"""
from log import logger


class CustomException(Exception):
    """Kontrolowany typ wyjątku."""


def sequence(name, start, end):
    value = start
    logger.info("%s rozpoczął od %i", name, value)
    while value < end:
        try:
            received = yield value
            logger.info("%s odebrał %r", name, received)
            value += 1
        except CustomException as e:
            logger.info("%s obsługuje %s", name, e)
            received = yield "OK"
    return end


def main():
    step1 = yield from sequence("pierwszy", 0, 5)
    step2 = yield from sequence("drugi", step1, 10)
    return step1 + step2
