"""Czysty kod w Pythonie - Rozdział 1: Wprowadzenie, formatowanie kodu i narzędzia

> Narzędzia dla podpowiedzi typu: przykłady
"""
from __future__ import annotations

import logging
from typing import Iterable

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)


def broadcast_notification(message: str, relevant_user_emails: Iterable[str]):
    for email in relevant_user_emails:
        logger.info("Wysyłam %r to %r", message, email)


broadcast_notification("witaj", ["user1@domain.com", "user2@domain.com"])
broadcast_notification("witaj", "user1@domain.com")
