"""Plik konfiguracji klienta BD
Zmodyfikuj ten plik według ustawień dla Twojego środowiska.
"""
import os


def _extract_from_env(variable, *, default=None):
    try:
        return os.environ[variable]

    except KeyError as e:
        if default is not None:
            return default

        raise RuntimeError(f"Zmienna środowiskowa {variable} nie jest ustawiona") from e


DB_CONFIG = {
    "user": _extract_from_env("DBUSER"),
    "password": _extract_from_env("DBPASSWORD"),
    "database": _extract_from_env("DBNAME"),
    "host": "db",
    "port": 5432,
}
