"""Czysty kod w Pythonie - Rozdział 6: Deskryptory

> Pierwszy przykład: naiwna implementacja z wykorzystaniem właściwości
"""


class Traveler:
    """Osoba odwiedzająca kilka miast.

    Chcemy śledzić ścieżkę podróżnika podczas, gdy odwiedza on
    kolejne miasta.
    """

    def __init__(self, name, current_city):
        self.name = name
        self._current_city = current_city
        self._cities_visited = [current_city]

    @property
    def current_city(self):
        return self._current_city

    @current_city.setter
    def current_city(self, new_city):
        if new_city != self._current_city:
            self._cities_visited.append(new_city)
        self._current_city = new_city

    @property
    def cities_visited(self):
        return self._cities_visited
