"""Czysty kod w Pythonie - Rozdział 6: Deskryptory

> Jak Python używa wewnętrznie deskryptorów: __slots__.

"""
from dataclasses import dataclass


@dataclass
class Coordinate2D:
    """Przykład klasy korzystającej ze słownika __slots__."""

    __slots__ = ("lat", "long")

    lat: float
    long: float

    def __repr__(self):
        return f"{self.__class__.__name__}({self.lat}, {self.long})"
