"""Czysty kod w Pythonie - Rozdział 5: Dekoratory

> functools.wraps
"""

from functools import wraps

from log import logger


def trace_decorator(function):
    """Logowanie momentu wywołania funkcji."""

    @wraps(function)
    def wrapped(*args, **kwargs):
        logger.info("uruchomiona funkcja %s", function.__qualname__)
        return function(*args, **kwargs)

    return wrapped


@trace_decorator
def process_account(account_id: str):
    """Przetwarzanie konta według identyfikatora."""
    logger.info("przetwarzanie konta %s", account_id)
    ...


def decorator(original_function):
    @wraps(original_function)
    def decorated_function(*args, **kwargs):
        # modyfikacje wprowadzone przez dekorator ...
        return original_function(*args, **kwargs)

    return decorated_function
