"""Czysty kod w Pythonie - Wydanie drugie
Rozdział 04 - Zasady SOLID

DIP: Zasada odwracania zależności

Demo podrozdziału poświęconego wstrzykiwaniu zależności.
"""
from __future__ import annotations

import json

from abc import ABCMeta, abstractmethod


class Event:
    def __init__(self, content: dict) -> None:
        self._content = content

    def serialise(self):
        return json.dumps(self._content)


class DataTargetClient(metaclass=ABCMeta):
    @abstractmethod
    def send(self, content: bytes):
        """Wysyła surową zawartość do określonego miejsca docelowego."""


class Syslog(DataTargetClient):
    def send(self, content: bytes):
        return f"[{self.__class__.__name__}] wysłała {len(content)} bajtów"


class EventStreamer:
    def __init__(self, target: DataTargetClient):
        self.target = target

    def stream(self, events: list[Event]) -> None:
        for event in events:
            self.target.send(event.serialise())
