"""Czysty kod w Pythonie. Rozdział 2. Kod pythoniczny

Klasy danych
"""

from typing import List
from dataclasses import dataclass, field


R = 26


@dataclass
class RTrieNode:
    size = R
    value: int
    next_: List["RTrieNode"] = field(
        default_factory=lambda: [None] * R
    )

    def __post_init__(self):
        if len(self.next_) != self.size:
            raise ValueError(f"Nieprawidłowa długość listy next")
