"""Czysty kod w Pythonie - Rozdział 1: Wprowadzenie, formatowanie kodu i narzędzia

> Dodatkowy kod dla wyizolowanych przykładów
"""


def data_from_response(response: dict) -> dict:
    """Jeśli odpowiedź jest prawidłowa, zwróć „ładunek” danych.
    - response: słownik następującej postaci::
    {
        "status": 200, # <int>
        "timestamp": "....", # format ISO bieżącej daty i godziny
        "payload": { ... } # słownik ze zwracanymi danymi
    }
    - Zwraca słownik postaci::
    {"data": { .. } }
    - Zgłasza wyjątki:
    - ValueError, jeśli status HTTP != 200
    """
    if response["status"] != 200:
        raise ValueError
    return {"data": response["payload"]}

