"""Czysty kod w Pythonie - Rozdział 6: Deskryptory

> Metody interfejsu deskryptora: __delete__

"""


class ProtectedAttribute:
    def __init__(self, requires_role=None) -> None:
        self.permission_required = requires_role
        self._name = None

    def __set_name__(self, owner, name):
        self._name = name

    def __set__(self, user, value):
        if value is None:
            raise ValueError(f"{self._name} nie można ustawić na None")
        user.__dict__[self._name] = value

    def __delete__(self, user):
        if self.permission_required in user.permissions:
            user.__dict__[self._name] = None
        else:
            raise ValueError(
                f"Użytkownik {user!s} nie ma uprawnień {self.permission_required} "
                
            )


class User:
    """Tylko użytkownicy z uprawnieniami "admin" mogą usunąć swój adres e-mail."""

    email = ProtectedAttribute(requires_role="admin")

    def __init__(
        self, username: str, email: str, permission_list: list = None
    ) -> None:
        self.username = username
        self.email = email
        self.permissions = permission_list or []

    def __str__(self):
        return self.username
