"""Czysty kod w Pythonie - Rozdział 5: Dekoratory

Test for separation of concerns with decorators.

"""
import unittest
from unittest import mock

from decorator_SoC_1 import operation1
from decorator_SoC_2 import operation


def mocked_time():
    _delta_time = 0

    def time():
        nonlocal _delta_time
        _delta_time += 1
        return _delta_time

    return time


@mock.patch("time.sleep")
@mock.patch("time.time", side_effect=mocked_time())
@mock.patch("decorator_SoC_1.logger")
class TestSoC1(unittest.TestCase):
    def test_operation(self, logger, time, sleep):
        operation1()
        expected_calls = [
            mock.call("początek działania funkcji %s", "operation1"),
            mock.call("uruchomiona funkcja operation1"),
            mock.call("działanie funkcji %s zajęło %.2fs", "operation1", 1),
        ]
        logger.info.assert_has_calls(expected_calls)


@mock.patch("time.sleep")
@mock.patch("time.time", side_effect=mocked_time())
@mock.patch("decorator_SoC_2.logger")
class TestSoC2(unittest.TestCase):
    def test_operation(self, logger, time, sleep):
        operation()
        expected_calls = [
            mock.call("początek działania funkcji %s", "operation"),
            mock.call("uruchomiona funkcja..."),
            mock.call("działanie funkcji %s zajęło %.2f", "operation", 1),
        ]
        logger.info.assert_has_calls(expected_calls)


if __name__ == "__main__":
    unittest.main()
