"""Czysty kod w Pythonie - Rozdział 5: Dekoratory

> PEP0614: Złagodzenie ograniczeń gramatyki dla dekoratorów
https://www.python.org/dev/peps/pep-0614/
"""


def _log(f, *args, **kwargs):
    print(f"wywoływanie {f.__qualname__!r} z argumentami {args=} i {kwargs=}")
    return f(*args, **kwargs)


@(lambda f: lambda *args, **kwargs: _log(f, *args, **kwargs))
def func(x):
    return x + 1
