"""Czysty kod w Pythonie - Rozdział 5: Dekoratory

> functools.wraps

"""

from log import logger


def trace_decorator(function):
    def wrapped(*args, **kwargs):
        logger.info("uruchomiona funkcja %s", function.__qualname__)
        return function(*args, **kwargs)

    return wrapped


@trace_decorator
def process_account(account_id: str):
    """Przetwarzanie konta według identyfikatora."""
    logger.info("przetwarzanie konta %s", account_id)
    ...
