"""Czysty kod w Pythonie - Rozdział 3: Ogólne cechy dobrego kodu

> Pakowanie / rozpakowanie
"""
from dataclasses import dataclass


USERS = [(i, f"first_name_{i}", f"last_name_{i}") for i in range(1_000)]


@dataclass
class User:
    user_id: int
    first_name: str
    last_name: str


def bad_users_from_rows(dbrows) -> list:
    """Zły, niepythoniczny sposób tworzenia obiektów ``User`` na podstawie wierszy z bazy danych."""
    return [User(row[0], row[1], row[2]) for row in dbrows]


def users_from_rows(dbrows) -> list:
    """Tworzenie obiektów ``User`` na podstawie wierszy z bazy danych."""
    return [
        User(user_id, first_name, last_name)
        for (user_id, first_name, last_name) in dbrows
    ]


def users_from_rows2(dbrows) -> list:
    """Tworzenie obiektów ``User`` na podstawie wierszy z bazy danych."""
    return [User(*row) for row in dbrows]
