// hc-sr04.ino - pomiar odległości z wykorzystaniem czujnika HC-SR04
// (c) BotBook.com - Karvinen, Karvinen, Valtokari


int trigPin = 8;	// <1>
int echoPin = 7;	// <2>
float v=331.5+0.6*20; // m/s	// <3>

void setup()	// <4>
{
  Serial.begin(9600);	// <5>
  pinMode(trigPin, OUTPUT);	// <6>
  pinMode(echoPin, INPUT);	// <7>
}

float distanceCm(){	// <8>
  // send sound pulse	// <9>
  digitalWrite(trigPin, LOW);	// <10>
  delayMicroseconds(3);	// <11>
  digitalWrite(trigPin, HIGH);	// <12>
  delayMicroseconds(5);	// <13>
  digitalWrite(trigPin, LOW);	// <14>

  // listen for echo 	// <15>
  float tUs = pulseIn(echoPin, HIGH); // mikrosekundy	// <16>
  float t = tUs / 1000.0 / 1000.0 / 2.0; // s	// <17>
  float d = t*v; // m	// <18>
  return d*100; // cm	// <19>
}

void loop()	// <20>
{
  int d=distanceCm(); // <21>
  Serial.println(d, DEC);	// <22>
  delay(200); // ms	// <23>
}

