# Zmiana haseł 
Poniżej znajdują się przykłady poleceń skutkujących zmianą haseł dla wszystkich kont użytkowników na danym komputerze

## Polecenie chpasswd dla Linux
Poniższe polecenie spowodue zmianę haseł dla wszystkich użytkowników systemu Linux, ustawiając losowe hasło, złożone z 9 znaków:
```
# while IFS=: read u x nn rest; do if [ $nn -ge 999 ]; then NEWPASS=`openssl rand -base64 9`; echo “${u]:${NEWPASSW}” | chpasswd; fi  done < /etc/passwd
```
## Zmiana haseł dla systemu Windows
Korzystając ze zmodyfikowanego skryptu Invoke-PasswordRoll.ps1 możesz zmienić hasła lokalnych użytkowników na komputerze pod kontrolą systemu Windows:
```
> Invoke-PasswordRoll -LocalAccounts @("Administrator", "example_user") -TsVFileName "newpws.tsv" -EncryptionKey "secretvalue"
```
Korzystając z oryginalnego skryptu Invoke-PasswordRoll.ps1 (https://support.microsoft.com/en-us/topic/ms14-025-vulnerability-in-group-policy-preferences-could-allow-elevation-of-privilege-may-13-2014-60734e15-af79-26ca-ea53-8cd617073c30) możesz zmienić hasła na zdalnym komputerze Windows:
```
> Invoke-PasswordRoll -Computer RemoteWinHost -LocalAccounts @("Administrator", "example_user") -TsVFileName "newpws.tsv" -EncryptionKey "secretvalue"
```
Aby odszyfrować nowe hasła użyj skryptu ConvertTo-CleartextPassword:
```
> ConvertTo-CleartextPassword -EncryptionKey "secretvalue" -EncryptedPassword 76492d1116743f0423413b16050a5345MgB8ADQANAB4AEcATwBkAGYATQA4AFQAWgBZAEsAOQBrAGYANQBpADMAOQBwAFEAPQA9AHwANwBjADEAZgA2ADgAMAAwADIAOAAxAGUANgBlADQAOQA2ADQAYwBkADUAYwBhADIANgA1ADgANwA5AGQAYwA4ADAAYgBiAGUAZgBhADkANwBlADMANwA2ADMAMQA3AGMAZQAyADIAZgA4ADMANwBiAGQANwA3ADcAYwAwADQAZgAyAGUANAAxAGEAZQA1ADcAYgAxADYAMABkADMAZABjADgAZQBhAGQAZgAyADIAZQBjADEAYgAwADkAZgA4AGMA
```
Poniższe polecenie wymusi u użytkowników domeny zmianę hasła przy kolejnym logowaniu:
```
> Get-ADUser -Filter * -SearchScope Subtree -SearchBase "OU=Accounts,DC=ad,DC=contoso,DC=com" | Set-ADUser -ChangePasswordAtLogon $true
```
