# Sztuczki z użyciem narzędzia iptables
Poniżej znajdują się przykłady użycia technik opartych o narzędzie iptables, które pozwalają zakłócać komunikację sieciową atakującego i skanowanie sieci

## Gubienie ruchu sieciowego

Poniższe poleceni spowoduje losowe gubienie 70% pakietów przychodzących w połaczeniach SSH:
```
$ sudo iptables -A INPUT -m statistic --mode random --probability 0.7 -s 0/0 -d 0/0 -p tcp --dport 22 -j DROP
```
Poniższe polecenie spowoduje gubienie 70% pakietów wychodzących, wysyłanych z portu 9999
```
$ sudo iptables -A OUTPUT -m statistic --mode random --probability 0.7 -s 0/0 -d 0/0 -p tcp --dport 9999 -j DROP
```
## Fałszywe porty
Poniższe polecenie spowoduje przekierowanie transmisji przychodzących poprzez wyszystkie porty, oprócz 22 i 80, na port lokalny 4444 (na którym powinno nasłuchiwać narzędzie takie jak portspoof (https://github.com/drk1wi/portspoof)):
```
$ sudo iptables -t nat -A PREROUTING -i eth0 -p tcp -m tcp -m multiport --dports 1:21,23:52,54:79,81:65535 -j REDIRECT --to-ports 4444
```
## Spowalnianie ruchu sieciowego
Poniższe polecenie wykorzystuje rozszerzenie Xtables_addons (https://inai.de/projects/xtables-addons/) dla iptables, a jego wykonanie spowoduje ustawienie zerowego rozmiaru okna TCP dla komunikacji poprzez port 3306, przy jednoczesnym pozostawieniu otwartego połączenia. Ta technika nazywana jest tarpit (dół ze smołą):
```
$ sudo iptables -A INPUT -p tcp --dport 3306 -j TARPIT
```
Ostatnie polecenie spowoduje wyczyszczenie wszelkich reguł iptables:
```
$ sudo iptables -F
```
