# Plik historii poleceń systemu Linux 
Poniższe polecenia umożliwiają usuwanie lub wzbogacanie pliku z historią wykonywanych poleceń w systemie Linux
## Wzbogacanie informacji o historii poleceń powłoki bash 
Poniższe polecenie spowoduje ustawienie nowej lokalizacji pliku z historią poleceń bash dla każdego nowo utworzonego użytkownika:
```
# echo 'HISTFILE=/var/log/user_history' >> /etc/skel/.bashrc
```
Poniższe polecenie spowoduje dodawanie znaczników czasu do pliku z historią poleceń bash dla każdego nowo utworzonego użytkownika:
```
# echo 'HISTTIMEFORMAT="%d/%m/%y %T"' >> /etc/skel/.bashrc
```
## Manipulowanie historią poleceń powłoki bash
Poniższym poleceniem możesz wstrzymać rejestrowanie historii poleceń bash dla bieżącego użytkownika:
```
$ unset HISTFILE
```
Poniższym poleceniem możesz także wyczyścić już zarejestrowaną historię poleceń bash dla bieżącego użytkownika:
```
$ history -c
```
Poniższym poleceniem możesz zapewnić, że dla tego konkretnego użytkownika w ogóle nie będzie rejestrowana historia poleceń bash:
```
$ echo "unset HISTFILE" >> ~/.bash_profile; echo "unset HISTFILE" >> ~/.bashrc;
```
Alernatywnie możesz sprawić, by historia polceceń bash była czyszczona za każdym razem, gdy użytkownik wylogowuje się:
```
$ echo 'history -c' >> ~/.bash_logout
```
Poniższe polecenie sprawi, że historia poleceń będzie rejestrowana pozornie bez zmian, a jedynie pomijane będą polecenia z wprowadzonymi wiodącymi spacjami:
```
$ HISTCONTROL=ignoredups:ignorespace
```
