# Analiza dziennika Sysmon 

## Narzędzie Get-WinEvent

Poniższe polecenie spowoduje wyświetlenie każdego zdarzenia DNS, zapisanego w dzienniku EventLog, wraz ze szczegółową zawartością komunikatu:
```
> Get-WinEvent -FilterHashtable @{logname="Microsoft-Windows-Sysmon/Operational"; id=22} | ForEach-Object {$_.message} 
```
Poniższe polecenie spowoduje wyświetlenie w kolejnych liniach wszystkie nazwy domen, wysyłanych w zapytaniach DNS
```
> Get-WinEvent -FilterHashtable @{logname="Microsoft-Windows-Sysmon/Operational"; id=22} | ForEach-Object {$_.message -split "`r`n"} | Select-String QueryName | %{$_.line.split()[-1]}
```

## Narzędzie Get-SysmonLogs
Poniższe polecenie wykorzystuje moduł Get-SysmonLogs stworzony przez 0DaySimpson (https://github.com/0daysimpson/Get-SysmonLogs), aby wygenerować taką samą listę nazw domen, jak w przypadku poprzedniego polecenia
```
> Import-Module Get-SysmonLogs.ps1
> Get-SysmonLogs -DNS  -Count 5 | ForEach-Object { $_.QueryName }
```
