#!/bin/bash -
#
# Operacje cyberbezpieczeństwa w bashu
# looper.sh
#
# Opis:
# Liczy wiersze w pliku przetwarzanego przez polecenie tailed -f
# Zwraca uzyskaną liczbę po przechwyceniu sygnału SIGUSR1
#
# Użycie: ./looper.sh [nazwapliku]
#   nazwapliku określa plik, który będzie monitorowany poleceniem tail; domyślny plik: log.file
# 

function interval ()					# <1>
{
    echo $(date '+%y%m%d %H%M%S') $cnt			# <2>
    cnt=0
}

declare -i cnt=0
trap interval SIGUSR1					# <3>

shopt -s lastpipe					# <4>

tail -f --pid=$$ ${1:-log.file} | while read aline	# <5>
do
    let cnt++
done
