#!/bin/bash -
#
# Operacje cyberbezpieczeństwa w bashu
# histogram_plain.sh
#
# Opis:
# Generuje poziomy wykres słupkowy na podstawie określonych danych
# bez użycia tablic asocjacyjnych; można z niego korzystać w starszych wersjach basha
#
# Użycie: ./histogram_plain.sh
#   format wejściowy: etykieta wartość
#

declare -a RA_key RA_val                                 # <1>
declare -i max ndx
max=0
maxbar=50    # wielkość najdłuższego słupka

ndx=0
while read labl val
do
    RA_key[$ndx]=$labl                                   # <2>
    RA_value[$ndx]=$val
    # zachowujemy największą wartość w celu skalowania
    (( val > max )) && max=$val 
    let ndx++
done

# skalujemy i wyświetlamy
for ((j=0; j<ndx; j++))                                  # <3>
do
    printf "%-20.20s  " ${RA_key[$j]}
    pr_bar ${RA_value[$j]} $max
done
