#!/bin/bash -
#
# Operacje cyberbezpieczeństwa w bashu
# validateconfig.sh
#
# Opis:
# Walidacja istnienia określonej konfiguracji 
#
# Użycie:
# validateconfig.sh < plikkonfiguracyjny
#
# tak wygląda specyfikacja konfiguracji:
# [[!]file|hash|reg|[!]user|[!]group] [argumenty] 
# Przykłady:
# file /usr/local/bin/sfx - plik istnieje
# hash 12384970347 /usr/local/bin/sfx - plik ma tę samą wartość skrótu
# !user bono - użytkownik “bono” nie ma uprawnień
# group students - musi mieć grupę studenci
#
# errexit - pokazuje poprawne użycie i kończy działanie
function errexit ()
{
    echo "błędna składnia w wierszu $ln"
    echo "użycie: [!]file|hash|reg|[!]user|[!]group [args]"    # <1>
    exit 2

} # errexit

# vfile - walidacja [nie]istnienia pliku
#   args: 1: flaga "nie" - wartość:1/0
#         2: nazwa pliku
#
function vfile ()
{
    local isThere=0
    [[ -e $2 ]] && isThere=1                    # <2>
    (( $1 )) && let isThere=1-$isThere          # <3>

    return $isThere

} # vfile

# weryfikacja identyfikatora użytkownika
function vuser ()
{
    local isUser
    $UCMD $2 &>/dev/null
    isUser=$?
    if (( $1 ))                                 # <4>
    then
        let isUser=1-$isUser
    fi

    return $isUser

} # vuser

# weryfikacja identyfikatora grupy
function vgroup ()
{
    local isGroup
    id $2 &>/dev/null
    isGroup=$?
    if (( $1 ))
    then
        let isGroup=1-$isGroup
    fi

    return $isGroup

} # vgroup

# weryfikacja wartości skrótu pliku
function vhash ()
{
    local res=0
    local X=$(sha1sum $2)                       # <5>
    if [[ ${X%% *} == $1 ]]                     # <6>
    then
        res=1
    fi

    return $res

} # vhash

# sprawdzenie rejestru systemu Windows
function vreg ()
{
    local res=0
    local keypath=$1
    local value=$2
    local expected=$3
    local REGVAL=$(query $keypath //v $value)

    if [[ $REGVAL == $expected ]]
    then
        res=1
    fi
    return $res

} # vreg

#
# main
#

# tę instrukcję wykonujemy jeden raz, aby móc zweryfikować identyfikatory użytkowników
UCMD="net user"
type -t net &>/dev/null  || UCMD="id"           # <7>

ln=0
while read cmd args
do
    let ln++

    donot=0
    if [[ ${cmd:0:1} == '!' ]]                  # <8>
    then
        donot=1
	basecmd=${cmd#\!}                       # <9>
    fi

    case "$basecmd" in
    file)
        OK=1
        vfile $donot "$args"
        res=$?
        ;;
    hash)
        OK=1
	# podział argumentów na pierwsze słowo i pozostałą część
        vhash "${args%% *}" "${args#* }"        # <10>
        res=$?
        ;;
    reg)
        # Tylko dla systemu Windows!
        OK=1
        vreg $args
        res=$?
        ;;
    user)
        OK=0
        vuser $args
        res=$?
        ;;
    group)
        OK=0
        vgroup $args
        res=$?
        ;;
    *)  errexit					# <11>
        ;;
    esac
    
    if (( res != OK )) 
    then
        echo "Niepowodzenie: [$ln] $cmd $args"
    fi
done

