#!/bin/bash -
#
# Operacje cyberbezpieczeństwa w bashu
# LocalRat.sh
#
# Opis:
# Narzędzie do zdalnego dostępu do systemu lokalnego,
# nasłuchuje na połączenia z systemu zdalnego
# i ułatwia transfer żądanego pliku 
#
# Użycie: LocalRat.sh port1 [port2 [port3]]
# 
#

# definiowanie demona transferu plików działającego w tle
function bgfilexfer ()
{
    while true
    do
        FN=$(nc -nlvvp $HOMEPORT2 2>>/tmp/x2.err)       # <3>
        if [[ $FN == 'exit' ]] ; then exit ; fi
        nc -nlp $HOMEPORT3 < $FN                        # <4>
    done
}


# -------------------- main ---------------------
HOMEPORT=$1
HOMEPORT2=${2:-$((HOMEPORT+1))}
HOMEPORT3=${3:-$((HOMEPORT2+1))}

# inicjalizacja demona transferu plików działającego w tle
bgfilexfer &                                            # <1>

# nasłuchiwanie na połączenia przychodzące 
nc -nlvp $HOMEPORT                                      # <2>

