#!/bin/bash -
#
# Operacje cyberbezpieczeństwa w bashu
# weblogfmt.sh
#
# Opis:
# Wczytuje plik dziennika serwera Apache i wyświetla go w formacie HTML
#
# Użycie:
# weblogfmt.sh <plik.wejściowy > plik.wyjściowy
#

function tagit()
{
	printf '<%s>%s</%s>\n' "${1}" "${2}" "${1}"
}

#podstawowe znaczniki nagłówka
echo "<html>"                                            # <1>
echo "<body>"
echo "<h1>$1</h1>"   #tytuł

echo "<table border=1>"   #tabela z ramką
echo "<tr>"   #nowy wiersz tabeli
echo "<th>Adres IP</th>"  # nagłówek kolumny
echo "<th>Data</th>"	
echo "<th>Żądany URL</th>"
echo "<th>Kod stanu</th>"
echo "<th>Rozmiar</th>"
echo "<th>Referrer</th>"
echo "<th>Agent użytkownika</th>"
echo "</tr>"

while read f1 f2 f3 f4 f5 f6 f7 f8 f9 f10 f11 f12plus    # <2>
do
	echo "<tr>"
	tagit "td" "${f1}"
	tagit "td" "${f4} ${f5}"                        # <3>
	tagit "td" "${f6} ${f7}"
	tagit "td" "${f9}"
	tagit "td" "${f10}"
	tagit "td" "${f11}"
	tagit "td" "${f12plus}"
	echo "</tr>"
done < $1

#znaczniki zamykające
echo "</table>"
echo "</body>"
echo "</html>"

