#!/bin/bash -
#
# Operacje cyberbezpieczeństwa w bashu
# typesearch.sh
#
# Opis:                                         
# Przeszukuje system plików pod kątem określonego typu plików. 
# Wyświetla znalezione ścieżki.
#
# Użycie:                   
# typesearch.sh [-c dir] [-i] [-R|r] <wzorzec> <ścieżka>
#   -c kopiuje znalezione pliki do katalogu dir         
#   -i Ignoruje wielkość liter      
#   -R|r Rekurencyjnie przeszukuje podkatalogi
#   <wzorzec> Wzorzec szukanego typu pliku
#   <ścieżka> Ścieżka do katalogu, w którym należy rozpocząć wyszukiwanie
#

DEEPORNOT="-maxdepth 1"		# jbieżący katalog; domyślnie

# Parsowanie argumentów:
while getopts 'c:irR' opt; do                         # <1>
  case "${opt}" in                                    # <2>
    c) # kopiuje znalezione pliki do podanego katalogu
	       COPY=YES
	       DESTDIR="$OPTARG"                             # <3>
	       ;;
    i) # ignoruje wielkość liter podczas wyszukiwania
	       CASEMATCH='-i'
	       ;;
    [Rr]) # rekurencja                                 # <4>
        unset DEEPORNOT;;                             # <5>
    *)  # nieznana/nieobsługiwana opcja               # <6>
        # polecenie getopts zwróci komunikat błędu, dlatego po prostu kończymy działanie
        exit 2 ;;
  esac
done
shift $((OPTIND - 1))                                 # <7>


PATTERN=${1:-PDF document}                            # <8>
STARTDIR=${2:-.}	# domyślnie zaczynamy od tego miejsca

find $STARTDIR $DEEPORNOT -type f | while read FN     # <9>
do
    file $FN | egrep -q $CASEMATCH "$PATTERN"          # <10>
    if (( $? == 0 ))   # znaleziono dopasowanie        # <11>
    then
	        echo $FN
	        if [[ $COPY ]]                               # <12>
	        then
	            cp -p $FN $DESTDIR                       # <13>
	        fi
    fi
done

