#!/bin/bash -
#
# Operacje cyberbezpieczeństwa w bashu
# pingmonitor.sh
#
# Opis:
# Użycie polecenia ping do monitorowania dostępności hosta
#
# Użycie:
# pingmonitor.sh <plik> <sekundy>
#   <plik> Plik zawierający listę hostów 
#   <sekundy> Liczba sekund między kolejnymi wywołaniami polecenia ping
#

while true
do
 clear	
 echo 'Monitor systemu cyberbezpieczeństwa'
 echo 'Status: Skanowanie ...'
 echo '-----------------------------------------'
 while read -r ipadd 
 do
  ipadd=$(echo "$ipadd" | sed 's/\r//')   #<1>
  ping -n 1 "$ipadd" | egrep '(Destination host unreachable|100%)' &> /dev/null   #<2>
  if (( "$?" == 0 ))   #<3>
  then
   tput setaf 1	#<4>
   echo "Host $ipadd nie został znaleziony - $(date)" | tee -a monitorlog.txt   #<5>
   tput setaf 7
  fi
 done < "$1"
	
 echo ""
 echo "Gotowe."

 for ((i="$2"; i > 0; i--))   #<6>
 do
  tput cup 1 0   #<7>
  echo "Status: Następne skanowanie za $i sekund"
  sleep 1
 done	
done
 
