#!/bin/bash -
#
# Operacje cyberbezpieczeństwa w bashu
# autoscan.sh
#
# Opis:
# Automatycznie skanuje porty (za pomocą skryptu scan.sh), 
# porównuje wynik z poprzednimi wynikami i wysyła wiadomości e-mail do użytkownika 
# Zakłada, że skrypt scan.sh znajduje się w bieżącym katalogu. 
#		 							
# Użycie: ./autoscan.sh
#

./scan.sh < hostlist                                      # <1>

FILELIST=$(ls scan_* | tail -2)                           # <2>
FILES=( $FILELIST )

TMPFILE=$(tempfile)                                       # <3>

./fd2.sh ${FILES[0]} ${FILES[1]}  > $TMPFILE

if [[ -s $TMPFILE ]]   # nie pusty                        # <4>
then
    echo "Wysyłanie dzisiejszych różnic w portach do użytkownika $USER"
    mail -s "Dzisiejsze różnice dotyczące portów" $USER < $TMPFILE   # <5>
fi
# czyszczenie
rm -f $TMPFILE                                            # <6>
