#!/bin/bash -
#
# Operacje cyberbezpieczeństwa w bashu
# useragents.sh
#
# Opis:
# Przetwarzanie wpisów w dziennikach pod kątem nieznanych agentów użytkownika
#
# Użycie: ./useragents.sh < <plikwejściowy> 
#   <plikwejściowy> dzienniki dostępu do serwera Apache 
#               
# mismatch - przeszukuje tablicę znanych nazw 
#  zwraca 1 (false) jeśli znajdzie dopasowanie
#  zwraca 0 (true) jeśli nie znajdzie dopasowania

function mismatch ()                                    # <1>
{
    local -i i                                          # <2>
    for ((i=0; i<$KNSIZE; i++))
    do
        [[ "$1" =~ .*${KNOWN[$i]}.* ]] && return 1      # <3>
    done
    return 0
}

# wczytuje znane nazwy
readarray -t KNOWN < "useragents.txt"                      # <4>
KNSIZE=${#KNOWN[@]}                                     # <5>

# wstępnie przetwarza plik dzienników (stdin) pod kątem adresu IP oraz agenta użytkownika 
awk -F'"' '{print $1, $6}' | \
while read ipaddr dash1 dash2 dtstamp delta useragent   # <6>
do
    if mismatch "$useragent"
    then
        echo "anomaly: $ipaddr $useragent"
    fi
done
