program cw4_42d;
{ Program wspomaga przeprowadzenie inwentaryzacji }
{ magazynu czesci komputerowych, ilustrujac       }
{ zastosowanie typu wyliczeniowego. Uzupelniony o }
{ mozliwosc wyswietlania zawartosci magazynu w    }
{ dowolnym miejscu. Pozwala na cofniecie ostat-   }
{ niego wpisu.                                    }
{ dyskietka: 4_42d.pas                            }

type
  TCzesci  = (monitor, klawiatura, obudowa, dysk);
  TMagazyn = array [TCzesci] of Integer;

const
  NazwyElementow : array [TCzesci] of String =
                   ('monitor', 'klawiatura', 'obudowa', 'dysk');

var
  Element : TCzesci;
  Magazyn : TMagazyn;
  Znak : Char;
  JestCoCofnac : Boolean;
  PoprzedniElement : TCzesci;

procedure WypiszMagazyn;
{ Procedura wypisuje zawartosc magazynu. }
var
  Element : TCzesci;
begin
  writeln ('Stan magazynu:');
  writeln ('==============');
  for Element:=monitor to dysk do
    writeln (NazwyElementow[Element]:10, ': ', Magazyn[Element]:6);
end; {---------------------------------------------- WypiszMagazyn -}


begin
  for Element:=monitor to dysk do
    Magazyn[Element] := 0;
  JestCoCofnac := False;

  repeat
    writeln ('Podaj litere oznaczajaca element: ');
    write ('M-monitor, K-klawiatura, ',
           'O-obudowa, D-dysk, W-wydruk, C-cofnij, spacja-koniec: ');
    readln (Znak); Znak := Upcase(Znak); writeln;
    if (Znak='M') then
      Element := monitor
    else
      if (Znak='K') then
        Element := klawiatura
      else
        if (Znak='O') then
          Element := obudowa
        else
          if (Znak='D') then
            Element := dysk
          else
            if (Znak='W') then
              WypiszMagazyn
            else
              if (Znak='C') then
              begin
                if (JestCoCofnac) then
                begin
                  writeln (' Cofnieto zliczanie poprzedniego elementu.');
                  Dec (Magazyn[PoprzedniElement]);
                  JestCoCofnac := False;
                  WypiszMagazyn;
                end
                else
                  writeln (' Nie da sie cofnac.');
              end
              else
                if (Znak<>' ') then
                begin
                  writeln (' Podano bledny znak. Nie zaliczono elementu');
                end;
    if ((Znak='M') or (Znak='K') or (Znak='O') or (Znak='D')) then
    begin
      JestCoCofnac := True;
      PoprzedniElement := Element;
      Inc (Magazyn[Element]);
      writeln (' Zaliczono element: ', NazwyElementow[Element], ' (',
                Magazyn[Element], ')');
    end;
  until Znak = ' ';

  WypiszMagazyn;

  readln;
end.