program cw3_64d;
{ Program testuje dzialanie funkcji, obliczajacej wartosc }
{ N-tej potegi rekurencyjnie i iteracyjnie.               }
{ dyskietka: 3_64d.pas                                    }


function PotegaIter (A: Real; N : Longint) : Real;
{ Funkcja oblicza A^N iteracyjnie. }
var
  I : Longint;
  Potega : Real;
begin
  Potega := 1;
  for I := 1 to N do 
    Potega := Potega*A;
  PotegaIter := Potega;
end; {------------------------------ PotegaIter -}

function PotegaReku (A: Real; N : Longint) : Real;
{ Funkcja oblicza A^N rekurencyjnie. }
begin
  if (N=0) then
    PotegaReku := 1
  else
    if not Odd(N) then
      PotegaReku := Sqr (PotegaReku (A, N div 2))
    else
      PotegaReku := A * Sqr (PotegaReku (A, N div 2))
end; {------------------------------ PotegaReku -}

begin
  write ('1^10000000 rekurencyjnie = '); writeln (PotegaReku(-1,10000000):0:2);
  write ('1^10000000 iteracyjnie = ');   writeln (PotegaIter(-1,10000000):0:2);
  readln;
end.