program cw4_37;
{ Program pokazujacy podstawowe dzialania w slowniku }
{ dodawanie elementu w odpowiednim pod wzgledem      }
{ alfabetycznym miejscu.                             }
{ Katalog r4_09 : 4_37.pas                           }

uses
  Crt;

type
  TWskaznik = ^TElement;
  TElement  = record
                Slowo : String;
                Nast  : TWskaznik;
              end;

var
  Slownik : TWskaznik;
  Slowo : String;

procedure Dodaj (Slowo: String);
{ Procedura dodaje slowo do slownika w odpowiednim }
{ (pod wzgledem alfabetycznym) miejscu.            }
var
  E, Pop, Nast : TWskaznik;

begin
  New (E);
  E^.Slowo := Slowo;
  if (Slownik = nil) or (Slownik^.Slowo>Slowo) then
  begin
    E^.Nast := Slownik; Slownik := E;
  end
  else
  begin
    Pop := Slownik; Nast := Slownik^.Nast;
    while (Nast <> nil) and (Nast^.Slowo<Slowo) do
    begin
      Pop := Nast;
      Nast := Nast^.Nast;
    end;
    E^.Nast := Nast;
    Pop^.Nast := E;
  end;
end; {------------------------------------- Dodaj -}

procedure WypiszSlownik;
{ Procedura wypisuje wszystkie elementy slownika.  }
var
  E : TWskaznik;
begin
  E := Slownik;
  while E <> nil do
begin
    Write (E^.Slowo, ' ');
    E := E^.Nast;
  end;
end; {----------------------------- WypiszSlownik -}

begin
  Slownik := nil;
  repeat
    ClrScr;
    Write ('Slownik: ');
    WypiszSlownik;
    Writeln;
    Write ('Podaj slowo (lub Enter by zakonczyc): ');
    Readln (Slowo);
    if (Slowo <> '') then Dodaj (Slowo);
  until (Slowo = '');
end.
