program cw4_45d;
{ Program testuje funkcje, podajace zapis slowny liczby. }
{ Katalog r4_11 : 4_45d.pas                                   }

function Slownie1 (Liczba : Longint) : String;
{ Funkcja podaje zapis slowny liczby wypisujac     }
{ po trzy pierwsze litery kazdej cyfry, oddzielone }
{ gwiazdkami.                                      }
const
  NazwyLiczb : array [0..9] of String [3] =
      ('zer', 'jed', 'dwa', 'trz', 'czt',
       'pie', 'sze', 'sie', 'osi', 'dzi');
var
  S : String;
begin
  S := '';
  while Liczba>=10 do
  begin
    if S = '' then
      S := NazwyLiczb[Liczba mod 10]
    else
      S := NazwyLiczb[Liczba mod 10]+'*'+S;
    Liczba := Liczba div 10;
  end;
  if S ='' then
    S := NazwyLiczb[Liczba]
  else
    S := NazwyLiczb[Liczba]+'*'+S;
  Slownie1 := S;
end; {---------------------------------- Slownie1 -}





function Slownie2 (Liczba : Longint) : String;
{ Funkcja podaje zapis slowny liczby (za M. Grondeckim). }

  type
    TNazwaRzedu = array [1..3] of String;

  const
    Cyfry : array ['0'..'9'] of String =
            ('zero ', 'jeden ', 'dwa ',  'trzy ', 'cztery ',
             'piec ', 'szesc ', 'siedem ', 'osiem ', 'dziewiec ');

    Nastki : array [11..19] of String =
             ('jedenascie ', 'dwanascie ', 'trzynascie ', 'czternascie ',
              'pietnascie ', 'szesnascie ', 'siedemnascie ', 'osiemnascie ',
              'dziewietnascie ');

    Dziestki : array ['1'..'9'] of String =
               ('dziesiec ', 'dwadziescia ', 'trzydziesci ', 'czterdziesci ', 'piedziesiat ',
                'szescdziesiat ', 'siedemdziesiat ', 'osiemdziesiat ', 'dziewiecdziesiat ');

    Setki : array ['1'..'9'] of String =
            ('sto ', 'dwiescie ', 'trzysta ', 'czterysta ', 'piecset ',
             'szescset ', 'siedemset ', 'osiemset ', 'dziewiecset ');

    Tysiace : TNazwaRzedu = ('tysiac ', 'tysiace ', 'tysiecy ');

    Miliony : TNazwaRzedu = ('milion ', 'miliony ', 'milionow ');

  function Value (S : String) : Integer;
  var
    E, V : Integer;
  begin
    Val (S, V, E); Value := V;
  end; {----------------------------- Value -}

  function Jednosci (Ile : String) : String;
  var
    Wynik   : String;
    Wartosc : Integer;
  begin
    Wynik := '';
    Jednosci := '';
    if (Ile = '000') then
      Exit;

    if (Ile [1] <> '0') and (Ile [1] <> ' ') then
      Wynik := Setki [Ile [1]];

    Ile:= Copy (Ile, 2, 2);
    Wartosc := Value (Ile);

    Jednosci := Wynik;
    if (Wartosc = 0) then
      Exit;

    if (Wartosc < 10) then
      Wynik := Wynik + Cyfry [Ile [2]]
    else
    if (Wartosc < 20) and (Wartosc <> 10) then
      Wynik := Wynik + Nastki [Wartosc]
    else
    begin
      if (Ile [1] <> '0') and (Ile [1] <> ' ') then
        Wynik := Wynik + Dziestki [Ile [1]];
      if (Ile [2] <> '0') and (Ile [2] <> ' ') then
        Wynik := Wynik + Cyfry [Ile [2]];
    end;

    Jednosci := Wynik;
  end; {--------------------------------- Jednosci -}

  function WiekszeRzedy (Ile        : String;
                         NazwaRzedu : TNazwaRzedu) : String;
  var
    Wynik   : String;
    Wartosc : Integer;
  begin
    Wartosc := Value (Ile);

    WiekszeRzedy := '';
    if (Wartosc = 0) then Exit;

    Wynik := Jednosci (Ile);

    if (Wartosc = 1) then
      Wynik := Wynik + NazwaRzedu [1]
    else
    if ((Ile[3] > '1') and (Ile[3] < '5')) and (Ile [2] <> '1') then
      Wynik := Wynik + NazwaRzedu[2]
    else
      Wynik := Wynik + NazwaRzedu[3];
    WiekszeRzedy := Wynik;
  end; {---------------------------------- WiekszeRzedy -}

var
  Reszta : Integer;
  Nazwa  : String;
  S      : String;
begin
  Slownie2 := 'zero';
  if (Liczba = 0) then Exit;

  Reszta := Liczba mod 1000; Liczba := Liczba div 1000;
  Str (Reszta:3, S); Nazwa := Jednosci (S);

  Reszta := Liczba mod 1000; Liczba := Liczba div 1000;
  Str (Reszta:3, S); Nazwa := WiekszeRzedy (S, Tysiace) + Nazwa;

  Reszta := Liczba mod 1000; Liczba := Liczba div 1000;
  Str (Reszta:3, S); Nazwa := WiekszeRzedy (S, Miliony) + Nazwa;

  Slownie2 := Nazwa;
end; {------------------------------------------ Slownie2 -}

var
  Liczba : Longint;

begin
  repeat
    Write ('Podaj liczbe: '); Readln (Liczba);
    Writeln ('Slownie 1: ', Slownie1 (Liczba));
    Writeln ('Slownie 2: ', Slownie2 (Liczba));
  until Liczba=0;
end.
