#include "ksztalt.h"
#include <QtGui>
#include <QTextCodec>
Ksztalt::Ksztalt(QWidget *parent) :
    QWidget(parent)
{
     QTextCodec::setCodecForCStrings(QTextCodec::codecForName("UTF-8"));
     setAcceptDrops(true);
     QLabel *l = new QLabel(this);
     l->setPixmap(QPixmap(QPixmap(":smile.png")));
     l->move(20,120);
     l->show();
     l->setAttribute(Qt::WA_DeleteOnClose);
}
void Ksztalt::paintEvent(QPaintEvent *)
{
    QPen pen(Qt::green,4, Qt::SolidLine);
    QPainter rysuj(this);
    rysuj.setPen(pen);
    //rysuj.drawLine(20,40,250,40);
    rysuj.drawEllipse(150,100,50,50);

}//funkcje do przenoszenia z QtAssistant
void Ksztalt::dragEnterEvent(QDragEnterEvent *event)
{
    if (event->mimeData()->hasFormat("application/x-dnditemdata")) {
            if (event->source() == this) {
                event->setDropAction(Qt::MoveAction);
                event->accept();
            } else {
                event->acceptProposedAction();
            }
        } else {
            event->ignore();
        }
}
void Ksztalt::dragMoveEvent(QDragMoveEvent *event)
{
    if (event->mimeData()->hasFormat("application/x-dnditemdata")) {
             if (event->source() == this) {
                 event->setDropAction(Qt::MoveAction);
                 event->accept();
             } else {
                 event->acceptProposedAction();
             }
         } else {
             event->ignore();
         }
}
void Ksztalt::dropEvent(QDropEvent *event)
{
    if (event->mimeData()->hasFormat("application/x-dnditemdata")) {
            QByteArray itemData = event->mimeData()->data("application/x-dnditemdata");
            QDataStream dataStream(&itemData, QIODevice::ReadOnly);

            QPixmap pixmap;
            QPoint offset;
            dataStream >> pixmap >> offset;

            QLabel *newIcon = new QLabel(this);
            newIcon->setPixmap(pixmap);
            newIcon->move(event->pos() - offset);
            newIcon->show();
            newIcon->setAttribute(Qt::WA_DeleteOnClose);

            if (event->source() == this) {
                event->setDropAction(Qt::MoveAction);
                event->accept();
            } else {
                event->acceptProposedAction();
            }
        } else {
            event->ignore();
        }
}
void Ksztalt::mousePressEvent(QMouseEvent *event)
{
    QLabel *child = static_cast<QLabel*>(childAt(event->pos()));
         if (!child)
             return;

         QPixmap pixmap = *child->pixmap();

         QByteArray itemData;
         QDataStream dataStream(&itemData, QIODevice::WriteOnly);
         dataStream << pixmap << QPoint(event->pos() - child->pos());

         QMimeData *mimeData = new QMimeData;
         mimeData->setData("application/x-dnditemdata", itemData);

         QDrag *drag = new QDrag(this);
         drag->setMimeData(mimeData);
         drag->setPixmap(pixmap);
         drag->setHotSpot(event->pos() - child->pos());

         QPixmap tempPixmap = pixmap;
         QPainter painter;
         painter.begin(&tempPixmap);
         painter.fillRect(pixmap.rect(), QColor(127, 127, 127, 127));
         painter.end();

         child->setPixmap(tempPixmap);

         if (drag->exec(Qt::CopyAction | Qt::MoveAction, Qt::CopyAction) == Qt::MoveAction)
             child->close();
         else {
             child->show();
             child->setPixmap(pixmap);
         }
}

