#ifndef HUFFMAN_H
#define HUFFMAN_H

#include <fstream>
#include <string>

struct Element
{
    int wart; //ilość wystąpień
    char znak;
    Element * l;
    Element * p;
    Element * rodzic;
    Element(int wart, char znak)
    {
        this->wart = wart;
        this->znak = znak;
        this->l = NULL;
        this->p = NULL;
        this->rodzic = NULL;
    }
};

class Builder
{
    public:
        Builder(std::ofstream *stream);
        void add(bool bit);
        void flush();
    private:
        char pom;
        short int wsk;
        std::ofstream *stream;
};

class Huffman
{
    public:
        Huffman();
        ~Huffman();
        void pakuj(std::ifstream *ifs, std::ofstream *stream);
 s    
    protected:
    private:
        void segreguj(int &a,int &b, int wartA, int wartB);
        int iloscZnakow;
        Element *all[256];
        Element * budujDrzewo(std::ifstream *ifs);
        Element * budujDrzewo(Element ** tab, int wielk_tab);
        void zapiszDrzewo(std::ifstream *ifs,std::ofstream *stream, Element *elem);
        void zapiszZnak(Builder *builder, Element *pom);
        void usunDrzewo(Element *elem);
};


class Reader
{
    public:
        Reader(std::ifstream *stream);
        bool hasNext();
        bool getNext();
    private:
        char pom;
        short int wsk;
        std::ifstream *stream;
};
#endif // HUFFMAN_H
