#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/wait.h>
#include <signal.h>
#include <time.h>

#define MSG_LEN 512
#define PORTNUM 60000
void  komunikacja (int cs2)
{
  int result;
  int a,b, wynik;
  char msg[MSG_LEN];

  memset(msg, 0, MSG_LEN);
  printf("Połączenie zaakceptowane.\n");

  strncpy(msg, "Podaj liczby: ", MSG_LEN);
  result = send(cs2, msg, strlen(msg), 0); //wyślij tekst do klienta
  if (result <= 0) {
    close(cs2);
    perror("send");
    exit(0);
  }

   memset(msg, 0, MSG_LEN);

    result = recv(cs2, msg, MSG_LEN, 0); //czekaj na odpowiedź klienta
      if (result <= 0) {
        close(cs2);
        perror("recv");
        exit(0);
      }
    msg[result-2]='\0';
   sscanf(msg,"%d %d",&a,&b);
   wynik=a+b;
   printf("wynik %d\n", wynik);
   sprintf(msg,"Wynik = %d",wynik);

   result = send(cs2, msg, strlen(msg)+1, 0);//wyślij tekst do klienta
   if (result < 0) {
     close(cs2);
     perror("send");
     exit(0);
   }
}
int main(void) {
  int s, result, cs = 0;
  struct sockaddr_in laddr;
  socklen_t laddr_len;
  int child_status, child_pid;
  sigset_t zbior;
/*utworzenie pustego zbioru sygnałów*/
sigemptyset(&zbior);
/*dodanie sygnałów*/
sigaddset(&zbior, SIGINT);// zwykle Ctrl + C
sigaddset(&zbior, SIGQUIT);// zwykle Ctrl +\ <- to nie działa w Code::Blocks
sigaddset(&zbior, SIGABRT);
sigaddset(&zbior, SIGTSTP);// zwykle Ctrl+Z
//sigaddset(&zbior, SIGTERM);//da się zablokować
sigaddset(&zbior, SIGKILL);//nie może być zignorowany lub przechwycony - nie da się zablokować
sigaddset(&zbior, SIGSTOP);//nie może być przechwycony lub zignorowany - da się zablokować w Code::Blocks - w terminalu nie

/*ustawienie blokady*/
sigprocmask(SIG_SETMASK, &zbior, NULL);

  s = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);//tworzymy gniazdo
  if (s < 0) {
    perror("socket");
    return 1;
  }

  memset(&laddr, 0, sizeof(struct sockaddr));

  laddr.sin_family = AF_INET;
  laddr.sin_port  = htons(PORTNUM);// serwer ma nasłuchiwać na porcie

  laddr.sin_addr.s_addr = htonl(INADDR_ANY);//każdy komputer może się połączyć

  result = bind(s, (struct sockaddr*)&laddr, sizeof(struct sockaddr));//bindujemy port z gniazdem
  if (result < 0) {
    close(s);
    perror("bind");
    return 1;
  }


  result = listen(s, 5);//ustawiamy gniazdo w tryb nasłuchiwania
  if (result < 0) {
    close(s);
    perror("listen");
    return 1;
  }

  laddr_len = sizeof(struct sockaddr);
while(1 )
{
cs = accept(s, (struct sockaddr*)&laddr, &laddr_len);
if (cs < 0)
{
    perror("accept");
    return 1;
    }
    else
    {
        child_pid = fork();
        switch (child_pid)
        {
            case -1 :
                /* błąd fork - brak procesu potomnego */
                break;
            case 0 :
                /* rodzic - zamknij gniazdo klienta */
                close (cs);
                /* czekaj na dalsze połączenia */
                break;
            default :
                /* dziecko - komunikacja z klientem */
                komunikacja (cs);
                exit (0);
        }
    }

 /* czekaj na zakończone procesy potomne, o ile są */
    for (child_status = 1; child_status > 0; child_status = waitpid(-1, NULL,WNOHANG))
        {/* pusta pętla */ ;}
}
  close(s);
/*usuniecie blokady*/
sigprocmask(SIG_UNBLOCK, &zbior, NULL);
  return 0;

}
