package pilka;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 *
 * @author kaya
 */
public class Panel extends JPanel{
    private ArrayList<Pilka> pilki = null;
    private Rysownik rysownik = null;

    class Rysownik implements Runnable {
        private Panel panel = null;
	//konstruktor
        Rysownik(Panel panel) {
            this.panel = panel;
        }

        @Override
        public void run() {
            while(true) {
                if(panel!=null)
                    panel.repaint();//odmalowanie ekranu
                try {
                    Thread.sleep(50);//uśpienie wątku

                } catch (InterruptedException ex) {
                    Logger.getLogger(Panel.class.getName()).log(Level.SEVERE, null, ex);//zapis błędów
                }
                
            }
        }
    }

    public static void main(String [] args) {
        JFrame frame = new JFrame();//utworzenie ramki
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);//reakcja na zamknięcie
        frame.setBounds(0, 0, 300, 300);
        Panel panel = new Panel();//nowy Panel
        panel.setDoubleBuffered(true);//podwójne buforowanie
//doanie panelu do ramki
        frame.add(panel);

        for(int i=0;i<30;i++) {//utworzenie piłek w pętki - wiele piłek
//nowy obiekt Pilka - nadanie prędkości i określenie położenia
            Pilka pilka = new Pilka(2+i,3+i*2,50+i,50+i*4);
//dodanie Pilki do Panelu
            panel.addPilka(pilka);
            Thread thread = new Thread(pilka);
            thread.setDaemon(true);
//uruchomienie wątku
            thread.start();
            
            
        }


        Thread thread = new Thread(panel.getRysownik());
         thread.setDaemon(true);
        thread.start();
       //ustawienie widoczności

        frame.setVisible(true);
    }

    public Panel() {
        pilki = new ArrayList<Pilka>();
        rysownik = new Rysownik(this);
    }

    public void addPilka(Pilka pilka) {
        pilki.add(pilka);
    }

    public Rysownik getRysownik() {
        return rysownik;
    }

    @Override
    public void paint(Graphics g){//rysowanie piłek na panelu
        super.paint(g);

        Iterator<Pilka> it = pilki.iterator();
        Pilka pilka = null;

        while(it.hasNext()) {
            pilka = it.next();
            g.setColor(Color.BLACK);
            g.fillRect((int)pilka.pozycjaX,(int)pilka.pozycjaY,5,5);
        }
    }

}
