


import java.io.FileOutputStream;


import java.util.Date;

import javax.swing.JOptionPane;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.PdfWriter;

import BiuroDAO.DyrektorDAO;
import KlasyApp.*;


public class NowyPDF {
	private static String FILE = "./pdfOut/FirstPdf.pdf";
	private static String IMG = "./img_/znak.png";
	private static Font tytul = new Font(Font.FontFamily.HELVETICA, 20, Font.BOLD);
	private static Font gen = new Font (Font.FontFamily.HELVETICA, 12, Font.ITALIC);
	private static Font rec = new Font(Font.FontFamily.HELVETICA,14,Font.NORMAL);

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		try {
			
		
		Document doc = new Document();
		PdfWriter.getInstance(doc, new FileOutputStream(FILE));
		doc.open();
		dodajMetaDane(doc);
		stronaTytulowa(doc);
		dodajObraz(doc);
		dodajDyrektora(doc);
		doc.close();
		JOptionPane.showConfirmDialog(null, "Plik został wygenerowany", "Generowanie", JOptionPane.DEFAULT_OPTION);
		} catch (Exception ex)
		{
			ex.printStackTrace();
		}

	}
	//dodanie danych widzianych przez "czytnik pdf" (Plik -> Właściwości)
	private static void dodajMetaDane(Document doc)
	{
		doc.addTitle("Pierwszy PDF");
		doc.addSubject("Biblioteka iText");
		doc.addKeywords("Java, PDF, iText");
		doc.addAuthor("Katarzyna Kuźniar");
		doc.addCreator("Katarzyna Kużniar");
	}
	private static void stronaTytulowa(Document doc)	throws DocumentException 
	{
		Paragraph paragraph = new Paragraph();
		// dodanie pustej linii
		PustaLinia(paragraph, 1);
		
		paragraph.add(new Paragraph("Dane dyrektora", tytul));
		
		PustaLinia(paragraph, 4);
		//informacje o wygenerowaniu pliku
		paragraph.add(new Paragraph(
				"Raport wygenerowany przez: " + System.getProperty("user.name") + ", " + new Date(), gen));
		doc.add(paragraph);
		
		
		
	}
	
	private static void dodajObraz(Document doc) throws Exception, Exception 
	{
		
		try {
			Image img = Image.getInstance(IMG);
			img.setAbsolutePosition(120f, 150f);
			doc.add(img);
		} catch (BadElementException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		
		}
			
	}
	private static void dodajDyrektora(Document doc)throws DocumentException 
	{
		Paragraph paragraph = new Paragraph();
		Dyrektor dyr =  DyrektorDAO.szukajPoId(3);
		int id = dyr.getId_dyr();
		String im =dyr.getImie();
		String naz = dyr.getNazwisko();
		paragraph.add(new Paragraph("Dyrektor: ",gen));
		PustaLinia(paragraph, 7);
		paragraph.add(new Paragraph("ID: "+id,rec));
		paragraph.add(new Paragraph("Imie: "+im,rec));
		paragraph.add(new Paragraph("Nazwisko: "+naz,rec));
		
		doc.add(paragraph);
	}
	private static void PustaLinia(Paragraph paragraph, int number) {
		for (int i = 0; i < number; i++) {
			paragraph.add(new Paragraph(" "));
		}
	}
}
