/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.ButtonGroup;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.plaf.DefaultLookAndFeel;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.UIManager;

public class RadioButton
extends Button {
    private boolean selected = false;
    private ButtonGroup group;

    public RadioButton(String text) {
        this(text, (Image)null);
    }

    public RadioButton() {
        this("");
    }

    public RadioButton(Image icon) {
        this("", icon);
    }

    public RadioButton(String text, Image icon) {
        super(text, icon);
        this.setUIID("RadioButton");
    }

    public String toString() {
        return "Radio Button " + this.getText();
    }

    int getAvaliableSpaceForText() {
        Image[] rButtonImages;
        LookAndFeel l = UIManager.getInstance().getLookAndFeel();
        if (l instanceof DefaultLookAndFeel && (rButtonImages = ((DefaultLookAndFeel)l).getRadioButtonImages()) != null) {
            int index = this.isSelected() ? 1 : 0;
            return super.getAvaliableSpaceForText() - rButtonImages[index].getWidth();
        }
        return super.getAvaliableSpaceForText() - (this.getHeight() + this.getGap());
    }

    public boolean isSelected() {
        return this.selected;
    }

    void setSelectedImpl(boolean selected) {
        this.selected = selected;
        this.repaint();
    }

    public void setSelected(boolean selected) {
        this.setSelectedImpl(selected);
        if (this.group != null && selected) {
            this.group.setSelected(this);
        }
    }

    void released() {
        if (!this.isSelected()) {
            this.setSelected(true);
        }
        super.released();
    }

    public void paint(Graphics g) {
        UIManager.getInstance().getLookAndFeel().drawRadioButton(g, this);
    }

    protected Dimension calcPreferredSize() {
        return UIManager.getInstance().getLookAndFeel().getRadioButtonPreferredSize(this);
    }

    void setGroup(ButtonGroup group) {
        this.group = group;
    }

    void fireActionEvent() {
        if (this.group != null) {
            this.group.setSelected(this);
        }
        super.fireActionEvent();
    }
}

