/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.table;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Label;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.TextField;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.table.TableLayout;
import com.sun.lwuit.table.TableModel;

public class Table
extends Container {
    private TableModel model;
    private Listener listener = new Listener();
    private boolean drawBorder = true;
    private boolean includeHeader = true;
    private int titleAlignment = 4;
    private int cellAlignment = 1;
    private boolean potentiallyDirtyModel;

    public Table(TableModel model) {
        this.model = model;
        this.updateModel();
        this.setUIID("Table");
    }

    public Table(TableModel model, boolean includeHeader) {
        this.setUIID("Table");
        this.includeHeader = includeHeader;
        this.model = model;
        this.updateModel();
    }

    public int getSelectedRow() {
        Component c;
        Form f = this.getComponentForm();
        if (f != null && (c = f.getFocused()) != null) {
            return this.getCellRow(c);
        }
        return -1;
    }

    public int getSelectedColumn() {
        Component c;
        Form f = this.getComponentForm();
        if (f != null && (c = f.getFocused()) != null) {
            return this.getCellColumn(c);
        }
        return -1;
    }

    private void updateModel() {
        Component c;
        int selectionRow = -1;
        int selectionColumn = -1;
        Form f = this.getComponentForm();
        if (f != null && (c = f.getFocused()) != null) {
            selectionRow = this.getCellRow(c);
            selectionColumn = this.getCellColumn(c);
        }
        this.removeAll();
        int columnCount = this.model.getColumnCount();
        if (this.includeHeader) {
            this.setLayout(new TableLayout(this.model.getRowCount() + 1, columnCount));
            for (int iter = 0; iter < columnCount; ++iter) {
                String name = this.model.getColumnName(iter);
                Component header = this.createCellImpl(name, -1, iter, false);
                TableLayout.Constraint con = this.createCellConstraint(name, -1, iter);
                this.addComponent(con, header);
            }
        } else {
            this.setLayout(new TableLayout(this.model.getRowCount(), columnCount));
        }
        for (int r = 0; r < this.model.getRowCount(); ++r) {
            for (int c2 = 0; c2 < columnCount; ++c2) {
                boolean e;
                Component cell;
                Object value = this.model.getValueAt(r, c2);
                if (value == null || (cell = this.createCellImpl(value, r, c2, e = this.model.isCellEditable(r, c2))) == null) continue;
                TableLayout.Constraint con = this.createCellConstraint(value, r, c2);
                int currentRow = ((TableLayout)this.getLayout()).getNextRow();
                if (currentRow > this.model.getRowCount()) {
                    return;
                }
                this.addComponent(con, cell);
                if (r != selectionRow || c2 != selectionColumn) continue;
                cell.requestFocus();
            }
        }
    }

    protected void paintGlass(Graphics g) {
        if (this.drawBorder) {
            int x;
            int xPos = this.getAbsoluteX();
            int yPos = this.getAbsoluteY();
            g.translate(xPos, yPos);
            int rows = this.model.getRowCount();
            int cols = this.model.getColumnCount();
            if (this.includeHeader) {
                ++rows;
            }
            g.setColor(this.getStyle().getFgColor());
            TableLayout t = (TableLayout)this.getLayout();
            int actualWidth = Math.max(this.getWidth(), this.getScrollDimension().getWidth());
            if (t.hasVerticalSpanning()) {
                for (int cellRow = 0; cellRow < rows - 1; ++cellRow) {
                    for (int cellColumn = 0; cellColumn < cols; ++cellColumn) {
                        if (cellRow + t.getCellVerticalSpan(cellRow, cellColumn) - 1 == rows - 1 || t.isCellSpannedThroughHorizontally(cellRow, cellColumn)) continue;
                        x = t.getColumnPosition(cellColumn);
                        int y = t.getRowPosition(cellRow);
                        int rowHeight = t.getRowPosition(cellRow + t.getCellVerticalSpan(cellRow, cellColumn)) - y;
                        int columnWidth = cellColumn < this.getModel().getColumnCount() - 1 ? t.getColumnPosition(cellColumn + 1) - x : this.getWidth() - y;
                        g.drawLine(x, y + rowHeight, x + columnWidth, y + rowHeight);
                    }
                }
            } else {
                for (int row = 1; row < rows; ++row) {
                    int y = t.getRowPosition(row);
                    g.drawLine(0, y, actualWidth, y);
                }
            }
            int actualHeight = Math.max(this.getHeight(), this.getScrollDimension().getHeight());
            if (t.hasHorizontalSpanning()) {
                for (int cellRow = 0; cellRow < rows; ++cellRow) {
                    for (int cellColumn = 0; cellColumn < cols - 1; ++cellColumn) {
                        if (cellColumn + t.getCellHorizontalSpan(cellRow, cellColumn) - 1 == cols - 1 || t.isCellSpannedThroughVertically(cellRow, cellColumn)) continue;
                        int x2 = t.getColumnPosition(cellColumn);
                        int y = t.getRowPosition(cellRow);
                        int columnWidth = t.getColumnPosition(cellColumn + t.getCellHorizontalSpan(cellRow, cellColumn)) - x2;
                        int rowHeight = cellRow < this.getModel().getRowCount() - 1 ? t.getRowPosition(cellRow + 1) - y : this.getHeight() - y;
                        g.drawLine(x2 + columnWidth, y, x2 + columnWidth, y + rowHeight);
                    }
                }
            } else {
                for (int col = 1; col < cols; ++col) {
                    x = t.getColumnPosition(col);
                    g.drawLine(x, 0, x, actualHeight);
                }
            }
            g.translate(-xPos, -yPos);
        }
    }

    private Component createCellImpl(Object value, int row, int column, boolean editable) {
        Component c = this.createCell(value, row, column, editable);
        c.putClientProperty("row", new Integer(row));
        c.putClientProperty("column", new Integer(column));
        if (c instanceof TextArea) {
            ((TextArea)c).addActionListener(this.listener);
        }
        Style s = c.getSelectedStyle();
        s.setMargin(0, 0, 0, 0);
        if (this.drawBorder) {
            s.setBorder(null);
            s = c.getUnselectedStyle();
            s.setBorder(null);
        } else {
            s = c.getUnselectedStyle();
        }
        s.setBgTransparency(0);
        s.setMargin(0, 0, 0, 0);
        return c;
    }

    protected Component createCell(Object value, int row, int column, boolean editable) {
        if (row == -1) {
            Label header = new Label((String)value);
            header.setUIID("TableHeader");
            header.setAlignment(this.titleAlignment);
            header.setFocusable(true);
            return header;
        }
        if (editable) {
            TextField cell = new TextField("" + value, -1);
            cell.setLeftAndRightEditingTrigger(false);
            cell.setUIID("TableCell");
            return cell;
        }
        Label cell = new Label("" + value);
        cell.setUIID("TableCell");
        cell.setAlignment(this.cellAlignment);
        cell.setFocusable(true);
        return cell;
    }

    public void initComponent() {
        if (this.potentiallyDirtyModel) {
            this.updateModel();
            this.potentiallyDirtyModel = false;
        }
        this.model.addDataChangeListener(this.listener);
    }

    public void deinitialize() {
        if (!Display.getInstance().isVirtualKeyboardShowing()) {
            this.potentiallyDirtyModel = true;
            this.model.removeDataChangeListener(this.listener);
        } else {
            this.potentiallyDirtyModel = false;
        }
    }

    public void setModel(TableModel model) {
        this.model = model;
        this.updateModel();
        this.revalidate();
    }

    public TableModel getModel() {
        return this.model;
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
        this.repaint();
    }

    public int getTitleAlignment() {
        return this.titleAlignment;
    }

    public void setTitleAlignment(int titleAlignment) {
        this.titleAlignment = titleAlignment;
        this.repaint();
    }

    public int getCellColumn(Component cell) {
        Integer i = (Integer)cell.getClientProperty("column");
        if (i != null) {
            return i;
        }
        return -1;
    }

    public int getCellRow(Component cell) {
        Integer i = (Integer)cell.getClientProperty("row");
        if (i != null) {
            return i;
        }
        return -1;
    }

    public int getCellAlignment() {
        return this.cellAlignment;
    }

    public void setCellAlignment(int cellAlignment) {
        this.cellAlignment = cellAlignment;
        this.repaint();
    }

    public boolean isIncludeHeader() {
        return this.includeHeader;
    }

    public void setIncludeHeader(boolean includeHeader) {
        this.includeHeader = includeHeader;
    }

    protected TableLayout.Constraint createCellConstraint(Object value, int row, int column) {
        if (this.includeHeader) {
            ++row;
        }
        TableLayout t = (TableLayout)this.getLayout();
        return t.createConstraint(row, column);
    }

    class Listener
    implements DataChangedListener,
    ActionListener {
        Listener() {
        }

        public final void dataChanged(int row, int column) {
            Object value = Table.this.model.getValueAt(row, column);
            boolean e = Table.this.model.isCellEditable(row, column);
            Component cell = Table.this.createCellImpl(value, row, column, e);
            TableLayout t = (TableLayout)Table.this.getLayout();
            TableLayout.Constraint con = Table.this.createCellConstraint(value, row, column);
            if (Table.this.includeHeader) {
                ++row;
            }
            Component c = t.getComponentAt(row, column);
            Table.this.removeComponent(c);
            c.setVisible(false);
            Table.this.addComponent(con, cell);
            Table.this.layoutContainer();
            cell.requestFocus();
            Table.this.revalidate();
        }

        public void actionPerformed(ActionEvent evt) {
            TextArea t = (TextArea)evt.getSource();
            int row = Table.this.getCellRow(t);
            int column = Table.this.getCellColumn(t);
            Table.this.getModel().setValueAt(row, column, t.getText());
        }
    }
}

