/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.Component;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.List;
import com.sun.lwuit.html.MultiListModel;
import com.sun.lwuit.list.DefaultListCellRenderer;

class MultiCellRenderer
extends DefaultListCellRenderer {
    private MultiListModel model;
    private boolean optgroup;
    private int bgColor = -1;
    private int fgColor = -1;

    MultiCellRenderer(MultiListModel model) {
        super(false);
        this.model = model;
    }

    void setOptgroup(boolean optgroup) {
        this.optgroup = optgroup;
    }

    public Component getListCellRendererComponent(List list, Object value, int index, boolean isSelected) {
        Component cmp = super.getListCellRendererComponent(list, value, index, isSelected);
        if (this.model.isSelected(value)) {
            this.setUIID("HTMLMultiComboBoxItem");
            this.fgColor = this.getUnselectedStyle().getFgColor();
            this.bgColor = this.getUnselectedStyle().getBgColor();
        } else {
            this.setUIID("ComboBoxItem");
            this.bgColor = -1;
            this.fgColor = -1;
        }
        if (this.optgroup) {
            if (value instanceof String) {
                this.setUIID("HTMLOptgroup");
            } else {
                this.setUIID("HTMLOptgroupItem");
            }
        }
        if (this.fgColor != -1) {
            this.getSelectedStyle().setFgColor(this.fgColor);
            this.getUnselectedStyle().setFgColor(this.fgColor);
        }
        return cmp;
    }

    public void paint(Graphics g) {
        if (this.hasFocus()) {
            g.setColor(this.getListFocusComponent(null).getSelectedStyle().getBgColor());
            g.fillRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        if (this.bgColor != -1) {
            g.setColor(this.bgColor);
            g.fillRect(this.getX() + this.getStyle().getPadding(1), this.getY() + this.getStyle().getPadding(0), this.getWidth() - this.getStyle().getPadding(1) - this.getStyle().getPadding(3), this.getHeight() - this.getStyle().getPadding(0) - this.getStyle().getPadding(2));
        }
        super.paint(g);
    }
}

