/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.html.CSSElement;
import com.sun.lwuit.html.DocumentInfo;
import com.sun.lwuit.html.DocumentRequestHandler;
import com.sun.lwuit.html.HTMLComponent;
import com.sun.lwuit.html.HTMLLink;
import com.sun.lwuit.html.Parser;
import com.sun.lwuit.html.ResourceThreadQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;

class ResourceThread
implements Runnable {
    Component imgLabel;
    Vector labels;
    String imageUrl;
    DocumentRequestHandler handler;
    ResourceThreadQueue threadQueue;
    boolean cancelled;
    HTMLComponent htmlC;
    Image img;
    DocumentInfo cssDocInfo;

    ResourceThread(String imageUrl, Component imgLabel, HTMLComponent htmlC, ResourceThreadQueue threadQueue) {
        this.imageUrl = imageUrl;
        this.imgLabel = imgLabel;
        this.handler = htmlC.getRequestHandler();
        this.threadQueue = threadQueue;
        this.htmlC = htmlC;
    }

    ResourceThread(DocumentInfo cssDocInfo, HTMLComponent htmlC, ResourceThreadQueue threadQueue) {
        this.cssDocInfo = cssDocInfo;
        this.handler = htmlC.getRequestHandler();
        this.threadQueue = threadQueue;
        this.htmlC = htmlC;
    }

    void cancel() {
        this.cancelled = true;
    }

    void addLabel(Component label) {
        if (this.labels == null) {
            this.labels = new Vector();
        }
        this.labels.addElement(label);
    }

    public void run() {
        block10: {
            try {
                InputStream is;
                DocumentInfo docInfo = this.cssDocInfo;
                if (docInfo == null) {
                    docInfo = new DocumentInfo(this.imageUrl, DocumentInfo.TYPE_IMAGE);
                }
                if ((is = this.handler.resourceRequested(docInfo)) == null) {
                    if (this.htmlC.getHTMLCallback() != null) {
                        this.htmlC.getHTMLCallback().parsingError(this.cssDocInfo != null ? 13 : 7, null, null, null, (this.cssDocInfo != null ? "CSS" : "Image") + " not found at " + (this.cssDocInfo != null ? this.cssDocInfo.getUrl() : this.imageUrl));
                    }
                } else {
                    if (this.cssDocInfo != null) {
                        CSSElement result = Parser.getInstance().parseCSSSegment(new InputStreamReader(is), is, this.htmlC, this.cssDocInfo.getUrl());
                        result.addAttribute(result.getAttributeName(new Integer(550)), this.cssDocInfo.getUrl());
                        this.htmlC.addToExternalCSS(result);
                        this.threadQueue.threadFinished(this, true);
                        return;
                    }
                    this.img = Image.createImage(is);
                    if (this.img == null && this.htmlC.getHTMLCallback() != null) {
                        this.htmlC.getHTMLCallback().parsingError(8, null, null, null, "Image could not be created from " + this.imageUrl);
                    }
                }
                if (this.img == null) {
                    this.threadQueue.threadFinished(this, false);
                    return;
                }
                if (!this.cancelled) {
                    Display.getInstance().callSerially(new Runnable(){

                        public void run() {
                            ResourceThread.this.handleImage(ResourceThread.this.img, ResourceThread.this.imgLabel);
                            if (ResourceThread.this.labels != null) {
                                Enumeration e = ResourceThread.this.labels.elements();
                                while (e.hasMoreElements()) {
                                    Component cmp = (Component)e.nextElement();
                                    ResourceThread.this.handleImage(ResourceThread.this.img, cmp);
                                }
                            }
                        }
                    });
                    this.threadQueue.threadFinished(this, true);
                }
            }
            catch (IOException ioe) {
                this.htmlC.getHTMLCallback().parsingError(8, null, null, null, "Image could not be created from " + this.imageUrl + ": " + ioe.getMessage());
                if (this.cancelled) break block10;
                this.threadQueue.threadFinished(this, false);
            }
        }
    }

    private void handleImage(Image img, Component cmp) {
        boolean bgUnselected = this.threadQueue.bgImageCompsUnselected.contains(cmp);
        boolean bgSelected = this.threadQueue.bgImageCompsSelected.contains(cmp);
        boolean bgPressed = this.threadQueue.bgImageCompsPressed.contains(cmp);
        this.handleImage(img, cmp, bgUnselected, bgSelected, bgPressed);
    }

    void handleImage(Image img, Component cmp, boolean bgUnselected, boolean bgSelected, boolean bgPressed) {
        boolean bg = false;
        if (bgUnselected) {
            cmp.getUnselectedStyle().setBgImage(img);
            bg = true;
        }
        if (bgSelected) {
            cmp.getSelectedStyle().setBgImage(img);
            bg = true;
        }
        if (bgPressed) {
            if (cmp instanceof HTMLLink) {
                ((HTMLLink)cmp).getPressedStyle().setBgImage(img);
            }
            bg = true;
        }
        if (bg) {
            cmp.repaint();
            return;
        }
        Label label = (Label)cmp;
        label.setText("");
        int width = label.getPreferredW() - label.getStyle().getPadding(1) - label.getStyle().getPadding(3);
        int height = label.getPreferredH() - label.getStyle().getPadding(0) - label.getStyle().getPadding(2);
        if (width != 0) {
            if (height == 0) {
                height = img.getHeight() * width / img.getWidth();
            }
        } else if (height != 0 && width == 0) {
            width = img.getWidth() * height / img.getHeight();
        }
        if (width != 0) {
            img = img.scaled(width, height);
            label.setPreferredSize(new Dimension(width += label.getStyle().getPadding(1) + label.getStyle().getPadding(3), height += label.getStyle().getPadding(0) + label.getStyle().getPadding(2)));
        }
        label.setIcon(img);
        this.htmlC.revalidate();
        label.getUnselectedStyle().setBorder(null);
    }
}

